package {
	
	import away3d.lights.DirectionalLight3D;
	import away3d.materials.WireColorMaterial;
	import away3d.primitives.Cube;
	
	import org.libspark.thread.Monitor;
	import org.libspark.thread.utils.EventDispatcherThread;

	public class SimpleCubeDemo extends EventDispatcherThread implements IDemoThread {
		
		private var _ctx:Context;
		private var _light:DirectionalLight3D;
		private var _cube:Cube;
		private var _monitor:Monitor;
		
		public function SimpleCubeDemo(ctx:Context) {
			this._ctx = ctx;
		}
		
		protected override function run():void {
			this._light = new DirectionalLight3D({x:0, y:100, z:-100, brightness: 3});
			this._ctx.arview.scene.addChild(this._light);
			var mat:WireColorMaterial = new WireColorMaterial(0xff0000);
			this._cube = new Cube({width:80, height:80, depth:80, material:mat});
			this._cube.y = 40;
			this._ctx.arview.marker.addChild(this._cube);
			
			this._monitor = new Monitor();
			this._monitor.wait();
		}
		
		public function close():void {
			this._monitor.notifyAll();
		}
		
		protected override function finalize():void {
			this._ctx.arview.scene.removeChild(this._light);
			this._ctx.arview.marker.removeChild(this._cube);
		}
	}
}